/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class MessagePortableGridItemDelta
implements IMessage,
IMessageHandler<MessagePortableGridItemDelta, IMessage> {
    private IPortableGrid portableGrid;
    private List<StackListResult<ItemStack>> deltas;
    private List<Pair<IGridStack, Long>> clientDeltas;

    public MessagePortableGridItemDelta(IPortableGrid portableGrid, List<StackListResult<ItemStack>> deltas) {
        this.portableGrid = portableGrid;
        this.deltas = deltas;
    }

    public MessagePortableGridItemDelta() {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.clientDeltas = new ArrayList<Pair<IGridStack, Long>>(size);
        for (int i = 0; i < size; ++i) {
            long delta = buf.readLong();
            this.clientDeltas.add((Pair<IGridStack, Long>)Pair.of((Object)StackUtils.readItemGridStack(buf), (Object)delta));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.deltas.size());
        for (StackListResult<ItemStack> delta : this.deltas) {
            buf.writeLong(delta.getChange());
            StackUtils.writeItemGridStack(buf, delta.getStack(), 0L, delta.getId(), null, false, this.portableGrid.getItemStorageTracker().get(delta.getStack()));
        }
    }

    public IMessage onMessage(MessagePortableGridItemDelta message, MessageContext ctx) {
        GuiBase.executeLater(GuiGrid.class, grid -> message.clientDeltas.forEach(p -> grid.getView().postChange((IGridStack)p.getLeft(), (Long)p.getRight())));
        return null;
    }
}

